import { StyleSheet } from "react-native";
import dpr from "../Utilities/CustomStyleAttribute/dpr";

export const myWishlistStyles = StyleSheet.create({
    container: {
        backgroundColor: "#fff",
        padding: dpr(20),
        paddingBottom: dpr(0),
        flex: 1
    },
    singleWishlistContainer: {
        display: "flex",
        flexDirection: "row",
        justifyContent: "space-between",
        marginBottom: dpr(20),
        backgroundColor: "#fff",
    },
    wishlistDetails: {
        display: "flex",
        flexDirection: "row",
        alignItems: "center",
    },
    imageCont: {
        backgroundColor: "#F1F1F1",
        height: dpr(80),
        width: dpr(80),
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
        marginRight: dpr(15),
        borderRadius: dpr(4),
    },
    image: {
        height: dpr(42),
        width: dpr(42),
        borderRadius: dpr(6),
    },
    text: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(16),
        color: "#898989",
        marginBottom: dpr(8),
        textAlign: 'left'
    },
    price: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
    },
    clearAllCont: {
        position: "absolute",
        right: dpr(20),
        top: dpr(28),
        height: dpr(64),
    },
    clearAllText: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(14),
        color: "#9B9B9B",
        lineHeight: dpr(17),
    },
});
